/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class UntypedAtomicConverter
extends UnaryExpression {
    private AtomicType requiredItemType;
    private boolean allConverted;
    private boolean singleton = false;

    public UntypedAtomicConverter(Expression sequence, AtomicType requiredItemType, boolean allConverted) {
        super(sequence);
        this.requiredItemType = requiredItemType;
        this.allConverted = allConverted;
        ExpressionTool.copyLocationInfo(sequence, this);
    }

    public ItemType getRequiredItemType() {
        return this.requiredItemType;
    }

    public boolean areAllItemsConverted() {
        return this.allConverted;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType it = this.operand.getItemType(th);
        boolean bl = this.singleton = it.isAtomicType() && !Cardinality.allowsMany(this.operand.getCardinality());
        if (this.allConverted) {
            return this.requiredItemType;
        }
        return Type.getCommonSuperType(this.requiredItemType, this.operand.getItemType(th), th);
    }

    public int computeCardinality() {
        if (this.singleton) {
            return 24576;
        }
        return super.computeCardinality();
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        this.operand = this.doPromotion(this.operand, offer);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.allConverted && this.requiredItemType.isNamespaceSensitive()) {
            XPathException err = new XPathException("Cannot convert untypedAtomic values to QNames or NOTATIONs");
            err.setErrorCode("XPTY0004");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        if (this.operand instanceof Literal) {
            return Literal.makeLiteral(((Value)SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))).reduce());
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType type = this.operand.getItemType(th);
        if (type instanceof NodeTest) {
            return this;
        }
        if (type.equals(BuiltInAtomicType.ANY_ATOMIC) || type instanceof AnyItemType || type.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return this;
        }
        return this.operand;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        return new UntypedAtomicConverter(this.getBaseExpression().copy(), this.requiredItemType, this.allConverted);
    }

    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        SequenceIterator base = this.operand.iterate(context);
        ItemMappingFunction converter = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                if (item instanceof UntypedAtomicValue) {
                    ConversionResult val = ((UntypedAtomicValue)item).convert(UntypedAtomicConverter.this.requiredItemType, true, context);
                    if (val instanceof ValidationFailure) {
                        ValidationFailure vex = (ValidationFailure)val;
                        vex.setLocator(UntypedAtomicConverter.this);
                        throw vex.makeException();
                    }
                    return (AtomicValue)val;
                }
                return item;
            }
        };
        return new ItemMappingIterator(base, converter);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = this.operand.evaluateItem(context);
        if (item == null) {
            return null;
        }
        if (item instanceof UntypedAtomicValue) {
            ConversionResult val = ((UntypedAtomicValue)item).convert(this.requiredItemType, true, context);
            if (val instanceof ValidationFailure) {
                ValidationFailure err = (ValidationFailure)val;
                err.setLocator(this);
                throw err.makeException();
            }
            return (AtomicValue)val;
        }
        return item;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("convertUntypedAtomic");
        out.emitAttribute("to", this.requiredItemType.toString(out.getConfiguration().getNamePool()));
        out.emitAttribute("all", this.allConverted ? "true" : "false");
        this.operand.explain(out);
        out.endElement();
    }

    protected String displayOperator(Configuration config) {
        return "convert untyped atomic items to " + this.requiredItemType.toString(config.getNamePool());
    }
}

